/*
 * Decompiled with CFR 0.152.
 */
package haven.launcher;

import haven.launcher.Config;
import haven.launcher.ErrorMessage;
import haven.launcher.Resource;
import haven.launcher.Status;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class AWTStatus
implements Status {
    private final JFrame frame;
    private boolean subsumed;
    private JPanel imgcont;
    private JPanel progcont;
    private JLabel message;
    private Component image;
    private JProgressBar prog;
    private URI splash;
    private URI icon;
    private static final String[] units = new String[]{"B", "kB", "MB", "GB", "TB", "PB"};
    private long lastsize;
    private long lastpos;
    private long lastupd;

    public AWTStatus() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.splash = null;
        this.icon = null;
        this.lastsize = -1L;
        this.lastpos = -1L;
        this.lastupd = 0L;
        this.frame = new JFrame("Launcher");
        this.frame.setResizable(false);
        JPanel cont = new JPanel();
        cont.setLayout(new BoxLayout(cont, 3));
        this.imgcont = new JPanel();
        this.imgcont.setLayout(new BoxLayout(this.imgcont, 2));
        this.image = Box.createHorizontalStrut(450);
        this.imgcont.add(this.image);
        cont.add(this.imgcont);
        this.progcont = new JPanel();
        this.progcont.setLayout(new BoxLayout(this.progcont, 2));
        this.message = new JLabel("Initializing...");
        this.progcont.add(this.message);
        this.progcont.add(Box.createGlue());
        cont.add(this.progcont);
        this.frame.add(cont);
        this.frame.pack();
        SwingUtilities.invokeLater(() -> {
            this.frame.setVisible(true);
            Dimension ssz = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension fsz = this.frame.getSize();
            this.frame.setLocation((ssz.width - fsz.width) / 2, (ssz.height - fsz.height) / 4);
        });
    }

    public JFrame subsume() {
        this.subsumed = true;
        return this.frame;
    }

    @Override
    public void dispose() {
        if (!this.subsumed) {
            this.frame.dispose();
        }
    }

    private void setimage(Path imgpath) throws IOException {
        BufferedImage img;
        try (InputStream fp = Files.newInputStream(imgpath, new OpenOption[0]);){
            img = ImageIO.read(fp);
        }
        SwingUtilities.invokeLater(() -> {
            JLabel nimage = new JLabel(new ImageIcon(img));
            this.imgcont.remove(this.image);
            this.image = nimage;
            this.imgcont.add(this.image);
            nimage.setAlignmentX(0.0f);
            this.frame.pack();
        });
    }

    @Override
    public boolean command(String[] argv, Config cfg, Config.Environment env) {
        switch (argv[0]) {
            case "splash-image": {
                Resource res;
                if (argv.length < 2) {
                    throw new RuntimeException("usage: splash-image URL");
                }
                try {
                    res = new Resource(env.rel.resolve(new URI(Config.expand(argv[1], env))), env.val).referrer(env.src);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("usage: splash-image URL", e);
                }
                if (!Objects.equals(res.uri, this.splash)) {
                    try {
                        this.setimage(res.update());
                        this.splash = res.uri;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                return true;
            }
            case "icon": {
                Resource res;
                if (argv.length < 2) {
                    throw new RuntimeException("usage: icon URL");
                }
                try {
                    res = new Resource(env.rel.resolve(new URI(Config.expand(argv[1], env))), env.val).referrer(env.src);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("usage: icon URL", e);
                }
                if (!Objects.equals(res.uri, this.icon)) {
                    try (InputStream fp = Files.newInputStream(res.update(), new OpenOption[0]);){
                        BufferedImage img = ImageIO.read(fp);
                        SwingUtilities.invokeLater(() -> this.frame.setIconImage(img));
                        this.icon = res.uri;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return true;
            }
            case "title": {
                if (argv.length < 2) {
                    throw new RuntimeException("usage: title TITLE");
                }
                String title = Config.expand(argv[1], env);
                SwingUtilities.invokeLater(() -> this.frame.setTitle(title));
                return true;
            }
        }
        return false;
    }

    @Override
    public void message(String text) {
        SwingUtilities.invokeLater(() -> {
            this.message.setText(text);
            if (this.prog != null) {
                this.progcont.remove(this.prog);
                this.prog = null;
            }
        });
    }

    private static String fmtbytes(long amount) {
        int ui = 0;
        long sz = 1L;
        while (ui < units.length - 1 && amount / sz >= 1000L) {
            ++ui;
            sz *= 1000L;
        }
        return String.format("%d %s", (amount + sz / 2L) / sz, units[ui]);
    }

    @Override
    public void transfer(long size, long pos) {
        SwingUtilities.invokeLater(() -> {
            long now = System.currentTimeMillis();
            if (size < 0L) {
                if (this.prog != null) {
                    this.progcont.remove(this.prog);
                    this.prog = null;
                }
            } else {
                if (this.prog == null) {
                    this.lastpos = -1L;
                    this.lastsize = -1L;
                    this.lastupd = 0L;
                    this.prog = new JProgressBar();
                    this.progcont.add(this.prog);
                    this.prog.setMinimumSize(new Dimension(100, 0));
                    this.prog.setStringPainted(true);
                }
                if (now - this.lastupd > 100L || pos >= size) {
                    this.prog.setMaximum((int)size);
                    this.prog.setValue((int)pos);
                    this.prog.setString(String.format("%s / %s", AWTStatus.fmtbytes(pos), AWTStatus.fmtbytes(size)));
                    this.lastupd = now;
                }
            }
            this.lastsize = size;
            this.lastpos = pos;
        });
    }

    @Override
    public void progress() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(Throwable exc, Frame owner) {
        final boolean[] done = new boolean[]{false};
        StringWriter buf = new StringWriter();
        exc.printStackTrace(new PrintWriter(buf));
        String trace = buf.toString();
        try {
            SwingUtilities.invokeAndWait(() -> {
                JDialog errwnd = new JDialog(owner, "Launcher error!", true);
                errwnd.setResizable(false);
                JPanel cont = new JPanel();
                cont.setLayout(new BoxLayout(cont, 3));
                String message = ErrorMessage.getmessage(exc);
                cont.add(new JLabel(message != null ? message : "An error has occurred!"));
                cont.add(new JLabel("If you want to report this, please including the following information:"));
                JTextArea body = new JTextArea(15, 80);
                body.setEditable(false);
                body.setText(trace);
                cont.add(new JScrollPane(body));
                errwnd.add(cont);
                errwnd.pack();
                errwnd.addWindowListener(new WindowAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void windowClosing(WindowEvent ev) {
                        boolean[] blArray = done;
                        synchronized (done) {
                            done[0] = true;
                            done.notifyAll();
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                    }
                });
                errwnd.setVisible(true);
            });
            boolean[] blArray = done;
            synchronized (done) {
                while (!done[0]) {
                    done.wait();
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        {
            return;
        }
    }

    @Override
    public void error(Throwable exc) {
        AWTStatus.error(exc, this.frame);
    }
}

