/*
 * Decompiled with CFR 0.152.
 */
package haven.launcher;

import haven.launcher.PosixArgs;
import haven.launcher.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Bootstrap {
    public static void bootstrap(OutputStream out, InputStream cfg) throws IOException {
        URL srcjar;
        try {
            srcjar = Bootstrap.class.getProtectionDomain().getCodeSource().getLocation();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not locate source Jar file", e);
        }
        ZipOutputStream outjar = new ZipOutputStream(out);
        byte[] buf = new byte[65536];
        ArrayList<String> seen = new ArrayList<String>();
        try (ZipInputStream injar = new ZipInputStream(srcjar.openConnection().getInputStream());){
            ZipEntry ent;
            while ((ent = injar.getNextEntry()) != null) {
                if (ent.getName().equals("haven/launcher/bootstrap.hl")) {
                    System.err.println("launcher: warning: removing current bootstrap");
                } else {
                    outjar.putNextEntry(ent);
                    int rv = injar.read(buf);
                    while (rv >= 0) {
                        outjar.write(buf, 0, rv);
                        rv = injar.read(buf);
                    }
                    seen.add(ent.getName().toLowerCase());
                }
                injar.closeEntry();
            }
        }
        if (!seen.contains("meta-inf/manifest.mf") || !seen.contains("haven/launcher/driver.class")) {
            throw new RuntimeException("Source Jar file appears corrupt or incomplete");
        }
        outjar.putNextEntry(new ZipEntry("haven/launcher/bootstrap.hl"));
        int rv = cfg.read(buf);
        while (rv >= 0) {
            outjar.write(buf, 0, rv);
            rv = cfg.read(buf);
        }
        outjar.finish();
    }

    private static void usage(PrintStream out) {
        out.println("usage: Bootstrap [-h] [BOOT-CONFIG|-] OUTPUT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PosixArgs opt = PosixArgs.getopt(args, "h");
        if (opt == null) {
            Bootstrap.usage(System.err);
            System.exit(1);
        }
        for (char c : opt.parsed()) {
            switch (c) {
                case 'h': {
                    Bootstrap.usage(System.out);
                    System.exit(0);
                }
            }
        }
        if (opt.rest.length < 2) {
            Bootstrap.usage(System.err);
            System.exit(1);
        }
        try {
            InputStream cfg;
            BufferedInputStream cl = null;
            if (opt.rest[0].equals("-")) {
                cfg = System.in;
            } else {
                cfg = new BufferedInputStream(Files.newInputStream(Utils.path(opt.rest[0]), new OpenOption[0]));
                cl = cfg;
            }
            Path outnm = Utils.path(opt.rest[1]);
            Path temp = outnm.resolveSibling(outnm.getFileName() + ".new");
            try {
                boolean done = false;
                try {
                    try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(temp, new OpenOption[0]));){
                        Bootstrap.bootstrap(out, cfg);
                    }
                    Files.move(temp, outnm, StandardCopyOption.ATOMIC_MOVE);
                    done = true;
                }
                finally {
                    if (!done) {
                        Files.delete(temp);
                    }
                }
            }
            finally {
                if (cl != null) {
                    ((InputStream)cl).close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

