/*
 * Decompiled with CFR 0.152.
 */
package haven.launcher;

import haven.launcher.Cached;
import haven.launcher.Config;
import haven.launcher.ErrorMessage;
import haven.launcher.Resource;
import haven.launcher.SslHelper;
import haven.launcher.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;

public class Cache {
    public static final String USER_AGENT;
    private final Path base = Cache.findbase();
    private static Cache global;
    private static final String safe = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_. ";
    private static final SslHelper ssl;

    private static Path findbase() {
        block14: {
            try {
                Path home;
                Path base;
                String path;
                block13: {
                    Path appdata;
                    path = System.getProperty("haven.launcher.cache-path");
                    if (path == null) {
                        path = System.getenv("LAUNCHER_CACHE");
                    }
                    if (path != null) {
                        Path base2 = Utils.path(path);
                        if (!(Files.exists(base2, new LinkOption[0]) && Files.isDirectory(base2, new LinkOption[0]) && Files.isReadable(base2) && Files.isWritable(base2))) {
                            throw new UnsupportedOperationException(base2 + ": cache does not exist or is not usable");
                        }
                        return base2;
                    }
                    path = System.getenv("LOCALAPPDATA");
                    if (path == null) {
                        path = System.getenv("APPDATA");
                    }
                    if (path != null && Files.exists(appdata = Utils.path(path), new LinkOption[0]) && Files.isDirectory(appdata, new LinkOption[0]) && Files.isReadable(appdata) && Files.isWritable(appdata)) {
                        base = Utils.pj(appdata, "Haven Launcher");
                        if (!Files.exists(base, new LinkOption[0])) {
                            try {
                                Files.createDirectories(base, new FileAttribute[0]);
                            }
                            catch (IOException e) {
                                break block13;
                            }
                        }
                        return base;
                    }
                }
                if ((path = System.getProperty("user.home", null)) == null || !Files.exists(home = Utils.path(path), new LinkOption[0]) || !Files.isDirectory(home, new LinkOption[0]) || !Files.isReadable(home) || !Files.isWritable(home)) break block14;
                base = Utils.pj(home, ".cache", "haven-launcher");
                if (!Files.exists(base, new LinkOption[0])) {
                    try {
                        Files.createDirectories(base, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        break block14;
                    }
                }
                return base;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        throw new UnsupportedOperationException("Found no reasonable place to store local files");
    }

    public static synchronized Cache get() {
        if (global == null) {
            global = new Cache();
        }
        return global;
    }

    private static String mangle(String el) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < el.length(); ++i) {
            char c = el.charAt(i);
            if (safe.indexOf(c) < 0 || i == 0 && c == '.') {
                char cc = c;
                if (c < '\u0100') {
                    buf.append(String.format("%%%02x", c));
                    continue;
                }
                buf.append(String.format("%%%04x", c));
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public Path mangle(URI uri) {
        Path ret = Utils.pj(this.base, "cache", Cache.mangle(uri.getScheme()));
        if (uri.getAuthority() != null) {
            ret = Utils.pj(ret, Cache.mangle(uri.getAuthority()));
        }
        String path = uri.getPath();
        int p = 0;
        while (true) {
            int n;
            if ((n = path.indexOf(47, p)) < 0) {
                n = path.length();
            }
            if (n > p) {
                ret = Utils.pj(ret, Cache.mangle(path.substring(p, n)));
            }
            if (n >= path.length()) break;
            p = n + 1;
        }
        if (uri.getQuery() != null) {
            ret = Utils.pj(ret, Cache.mangle(uri.getQuery()));
        }
        return ret;
    }

    public Path metafile(URI uri, String var) {
        Path ret = this.mangle(uri);
        return ret.resolveSibling("." + ret.getFileName() + "." + var);
    }

    private void addcert(Collection<String> buf, Certificate cert) {
        try {
            MessageDigest dig;
            buf.add("dig:sha256:" + Utils.byte2hex(MessageDigest.getInstance("SHA-256").digest(cert.getEncoded())));
            PublicKey key = cert.getPublicKey();
            if (key instanceof RSAPublicKey) {
                RSAPublicKey rsakey = (RSAPublicKey)key;
                dig = MessageDigest.getInstance("SHA-256");
                dig.update(rsakey.getPublicExponent().toString().getBytes(Utils.utf8));
                dig.update(new byte[]{58});
                dig.update(rsakey.getModulus().toString().getBytes(Utils.utf8));
                buf.add("key:rsa:" + Utils.byte2hex(dig.digest()));
            }
            if (key instanceof DSAPublicKey) {
                DSAPublicKey dsakey = (DSAPublicKey)key;
                dig = MessageDigest.getInstance("SHA-256");
                DSAParams dsapar = dsakey.getParams();
                dig.update(dsapar.getG().toString().getBytes(Utils.utf8));
                dig.update(new byte[]{58});
                dig.update(dsapar.getP().toString().getBytes(Utils.utf8));
                dig.update(new byte[]{58});
                dig.update(dsapar.getQ().toString().getBytes(Utils.utf8));
                dig.update(new byte[]{58});
                dig.update(dsakey.getY().toString().getBytes(Utils.utf8));
                buf.add("key:dsa:" + Utils.byte2hex(dig.digest()));
            }
        }
        catch (CertificateEncodingException key) {
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static boolean dokludgerepl() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Windows");
    }

    private static void overwrite(Path dst, Path src) throws IOException {
        try (InputStream in = Files.newInputStream(src, new OpenOption[0]);
             OutputStream out = Files.newOutputStream(dst, new OpenOption[0]);){
            byte[] buf = new byte[65536];
            int rv = in.read(buf);
            while (rv >= 0) {
                out.write(buf, 0, rv);
                rv = in.read(buf);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private Cached update0(Resource res, boolean force) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Cached update(Resource res, boolean force) throws IOException {
        ArrayList<IOException> errors = new ArrayList<IOException>();
        for (int retry = 0; retry < 3; ++retry) {
            try {
                return this.update0(res, force);
            }
            catch (IOException e) {
                errors.add(e);
                force = true;
                continue;
            }
        }
        IOException first = (IOException)errors.get(0);
        for (int i = 1; i < errors.size(); ++i) {
            first.addSuppressed((Throwable)errors.get(i));
        }
        throw first;
    }

    static {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("Haven-Launcher/%d.%d", Config.MAJOR_VERSION, Config.MINOR_VERSION));
        String jv = System.getProperty("java.version");
        if (jv != null && jv.length() > 0) {
            buf.append(String.format(" Java/%s", jv));
        }
        USER_AGENT = buf.toString();
        global = null;
        ssl = new SslHelper();
    }

    public static class FileReplaceException
    extends IOException
    implements ErrorMessage {
        public FileReplaceException(Throwable cause) {
            super("could not replace out-of-date file with newly downloaded file", cause);
        }

        @Override
        public String usermessage() {
            return "Could not replace out-of-date file with newly downloaded file. If the program is currently running, please quit it and try again.";
        }
    }
}

