/*
 * Decompiled with CFR 0.152.
 */
package haven.launcher;

import haven.launcher.ChainLauncher;
import haven.launcher.CommandHandler;
import haven.launcher.ErrorMessage;
import haven.launcher.Extension;
import haven.launcher.JavaLauncher;
import haven.launcher.Launcher;
import haven.launcher.Resource;
import haven.launcher.Status;
import haven.launcher.Utils;
import haven.launcher.Validator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Config {
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 5;
    public final Collection<Resource> include = new ArrayList<Resource>();
    public final Collection<URI> included = new HashSet<URI>();
    public final Collection<URI> exts = new HashSet<URI>();
    public final Collection<CommandHandler> mods = new ArrayList<CommandHandler>();
    public Launcher launcher = new JavaLauncher();

    public static int iparcmp(String a, String b) {
        int y;
        int x;
        try {
            x = Integer.parseInt(a);
        }
        catch (NumberFormatException e) {
            x = Integer.MIN_VALUE;
        }
        try {
            y = Integer.parseInt(b);
        }
        catch (NumberFormatException e) {
            y = Integer.MIN_VALUE;
        }
        return x < y ? -1 : (x > y ? 1 : 0);
    }

    public static List<?> verparse(String ver) {
        ArrayList<Object> ret = new ArrayList<Object>();
        int p = 0;
        while (p < ver.length()) {
            char c;
            if ((c = ver.charAt(p++)) >= '0' && c <= '9') {
                int n = c - 48;
                while (p < ver.length() && (c = ver.charAt(p)) >= '0' && c <= '9') {
                    ++p;
                    n = n * 10 + (c - 48);
                }
                ret.add(n);
                continue;
            }
            StringBuilder buf = new StringBuilder();
            buf.append(c);
            while (p < ver.length() && ((c = ver.charAt(p)) < '0' || c > '9')) {
                ++p;
                buf.append(c);
            }
            ret.add(buf.toString());
        }
        return ret;
    }

    public static int vparcmp(String a, String b) {
        int p;
        List<?> x = Config.verparse(a);
        List<?> y = Config.verparse(b);
        for (p = 0; p < x.size() && p < y.size(); ++p) {
            Object j = x.get(p);
            Object k = y.get(p);
            if (j instanceof Integer && k instanceof String) {
                return -1;
            }
            if (!(j instanceof String) || !(k instanceof Integer)) continue;
            return 1;
        }
        if (x.size() > p) {
            return 1;
        }
        if (y.size() > p) {
            return -1;
        }
        return 0;
    }

    public static String expand(String s, Environment env) {
        StringBuilder buf = new StringBuilder();
        int p = 0;
        while (p < s.length()) {
            char c;
            if ((c = s.charAt(p++)) == '$') {
                char x;
                if (p >= s.length()) {
                    throw new RuntimeException("unexpected expansion at end-of-line: " + s);
                }
                if ((x = s.charAt(p++)) == '$') {
                    buf.append('$');
                    continue;
                }
                if (x == '{') {
                    int p2 = s.indexOf(125, p);
                    if (p2 < 0) {
                        throw new RuntimeException("unterminated parameter expansion: " + s);
                    }
                    String par = s.substring(p, p2);
                    p = p2 + 1;
                    if (par.startsWith("p:")) {
                        buf.append(System.getProperty(par.substring(2), ""));
                        continue;
                    }
                    buf.append(env.par.getOrDefault(par, ""));
                    continue;
                }
                throw new RuntimeException("unknown expansion `" + x + "': " + s);
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private void when(String[] words, Environment env) {
        int a;
        block27: {
            a = 1;
            while (true) {
                String w;
                if (a >= words.length) {
                    throw new RuntimeException("unterminated `when' stanza: " + Arrays.asList(words));
                }
                if ((w = words[a++]).equals(":")) break block27;
                if (w.equals("!")) {
                    if (a >= words.length) {
                        throw new RuntimeException("unexpected `when' operator at end-of-line: " + Arrays.asList(words));
                    }
                    if (Config.expand(words[a++], env).equals("")) continue;
                    return;
                }
                if (w.equals("==")) {
                    if (a >= words.length - 1) {
                        throw new RuntimeException("unexpected `when' operator at end-of-line: " + Arrays.asList(words));
                    }
                    if (Config.expand(words[a++], env).equals(Config.expand(words[a++], env))) continue;
                    return;
                }
                if (w.equals("!=")) {
                    if (a >= words.length - 1) {
                        throw new RuntimeException("unexpected `when' operator at end-of-line: " + Arrays.asList(words));
                    }
                    if (!Config.expand(words[a++], env).equals(Config.expand(words[a++], env))) continue;
                    return;
                }
                if (w.startsWith("~=")) {
                    if (a >= words.length - 1) {
                        throw new RuntimeException("unexpected `when' operator at end-of-line: " + Arrays.asList(words));
                    }
                    int fl = 0;
                    if (w.indexOf(105) >= 0) {
                        fl |= 2;
                    }
                    if (Pattern.compile(words[a++], fl).matcher(Config.expand(words[a++], env)).matches()) continue;
                    return;
                }
                if (w.equals(">")) {
                    if (a >= words.length - 1) {
                        throw new RuntimeException("unexpected `when' operator at end-of-line: " + Arrays.asList(words));
                    }
                    if (Config.iparcmp(Config.expand(words[a++], env), Config.expand(words[a++], env)) > 0) continue;
                    return;
                }
                if (w.equals(">=")) {
                    if (a >= words.length - 1) {
                        throw new RuntimeException("unexpected `when' operator at end-of-line: " + Arrays.asList(words));
                    }
                    if (Config.iparcmp(Config.expand(words[a++], env), Config.expand(words[a++], env)) >= 0) continue;
                    return;
                }
                if (w.equals("<")) {
                    if (a >= words.length - 1) {
                        throw new RuntimeException("unexpected `when' operator at end-of-line: " + Arrays.asList(words));
                    }
                    if (Config.iparcmp(Config.expand(words[a++], env), Config.expand(words[a++], env)) < 0) continue;
                    return;
                }
                if (w.equals("<=")) {
                    if (a >= words.length - 1) {
                        throw new RuntimeException("unexpected `when' operator at end-of-line: " + Arrays.asList(words));
                    }
                    if (Config.iparcmp(Config.expand(words[a++], env), Config.expand(words[a++], env)) <= 0) continue;
                    return;
                }
                if (w.equals(".>")) {
                    if (a >= words.length - 1) {
                        throw new RuntimeException("unexpected `when' operator at end-of-line: " + Arrays.asList(words));
                    }
                    if (Config.vparcmp(Config.expand(words[a++], env), Config.expand(words[a++], env)) > 0) continue;
                    return;
                }
                if (w.equals(".>=")) {
                    if (a >= words.length - 1) {
                        throw new RuntimeException("unexpected `when' operator at end-of-line: " + Arrays.asList(words));
                    }
                    if (Config.vparcmp(Config.expand(words[a++], env), Config.expand(words[a++], env)) >= 0) continue;
                    return;
                }
                if (w.equals(".<")) {
                    if (a >= words.length - 1) {
                        throw new RuntimeException("unexpected `when' operator at end-of-line: " + Arrays.asList(words));
                    }
                    if (Config.vparcmp(Config.expand(words[a++], env), Config.expand(words[a++], env)) < 0) continue;
                    return;
                }
                if (w.equals(".<=")) {
                    if (a >= words.length - 1) {
                        throw new RuntimeException("unexpected `when' operator at end-of-line: " + Arrays.asList(words));
                    }
                    if (Config.vparcmp(Config.expand(words[a++], env), Config.expand(words[a++], env)) <= 0) continue;
                    return;
                }
                if (Config.expand(w, env).equals("")) break;
            }
            return;
        }
        this.command(Arrays.copyOfRange(words, a, words.length), env);
    }

    public void add(CommandHandler mod) {
        this.mods.add(mod);
    }

    public void command(String[] words, Environment env) {
        if (words == null || words.length < 1) {
            return;
        }
        for (CommandHandler mod : this.mods) {
            if (!mod.command(words, this, env)) continue;
            return;
        }
        if (Status.current().command(words, this, env)) {
            return;
        }
        if (this.launcher.command(words, this, env)) {
            return;
        }
        switch (words[0]) {
            case "require": {
                int min;
                int maj;
                if (words.length < 2) {
                    throw new RuntimeException("usage: require MAJOR.MINOR");
                }
                try {
                    int p = words[1].indexOf(46);
                    if (p < 0) {
                        throw new RuntimeException("usage: require MAJOR.MINOR");
                    }
                    maj = Integer.parseInt(words[1].substring(0, p));
                    min = Integer.parseInt(words[1].substring(p + 1));
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("usage: require MAJOR.MINOR", e);
                }
                if (maj == MAJOR_VERSION && min <= MINOR_VERSION) break;
                throw new InvalidVersionException(maj + "." + min);
            }
            case "error": {
                if (words.length < 2) {
                    throw new RuntimeException("usage: error MESSAGE");
                }
                throw new UserError(words[1]);
            }
            case "rel": {
                if (words.length < 2) {
                    throw new RuntimeException("usage: rel URI");
                }
                try {
                    env.rel(new URI(Config.expand(words[1], env)));
                    break;
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("usage: rel URL", e);
                }
            }
            case "validate": {
                if (words.length < 2) {
                    throw new RuntimeException("usage: validate VALIDATOR...");
                }
                ArrayList<Validator> nval = new ArrayList<Validator>();
                for (int i = 1; i < words.length; ++i) {
                    Validator v = Validator.parse(Config.expand(words[i], env));
                    if (v == null) continue;
                    nval.add(v);
                }
                env.val = nval;
                break;
            }
            case "include": {
                if (words.length < 2) {
                    throw new RuntimeException("usage: include URL");
                }
                try {
                    this.include.add(new Resource(env.rel.resolve(new URI(Config.expand(words[1], env))), env.val).referrer(env.src));
                    break;
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("usage: include URL", e);
                }
            }
            case "extension": {
                URI uri;
                if (words.length < 2) {
                    throw new RuntimeException("usage: extension URL");
                }
                try {
                    uri = env.rel.resolve(new URI(Config.expand(words[1], env)));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("usage: extension URL", e);
                }
                if (this.exts.contains(uri)) break;
                try {
                    for (Extension ext : Extension.load(new Resource(uri, env.val).referrer(env.src))) {
                        ext.init(this);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("could not load extension: " + String.valueOf(uri), e);
                }
                this.exts.add(uri);
                break;
            }
            case "set": {
                if (words.length < 3) {
                    throw new RuntimeException("usage: set VARIABLE VALUE");
                }
                HashMap<String, String> par = new HashMap<String, String>(env.par);
                par.put(Config.expand(words[1], env), Config.expand(words[2], env));
                env.par(par);
                break;
            }
            case "when": {
                this.when(words, env);
                break;
            }
            case "chain": {
                if (words.length < 2) {
                    throw new RuntimeException("usage: chain URL");
                }
                try {
                    this.launcher = new ChainLauncher(new Resource(env.rel.resolve(new URI(Config.expand(words[1], env))), env.val).referrer(env.src));
                    break;
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("usage: chain URL", e);
                }
            }
        }
    }

    public void read(Reader in, Environment env) throws IOException {
        BufferedReader fp = new BufferedReader(in);
        String ln = fp.readLine();
        while (ln != null) {
            if (ln.length() <= 0 || ln.charAt(0) != '#') {
                this.command(Utils.splitwords(ln), env);
            }
            ln = fp.readLine();
        }
    }

    public static class UserError
    extends RuntimeException
    implements ErrorMessage {
        public UserError(String message) {
            super(message);
        }

        @Override
        public String usermessage() {
            return this.getMessage();
        }
    }

    public static class InvalidVersionException
    extends RuntimeException
    implements ErrorMessage {
        public final String required;

        public InvalidVersionException(String required) {
            super(String.format("invalid version of launcher; launch file requires %s, this is %d.%d", required, MAJOR_VERSION, MINOR_VERSION));
            this.required = required;
        }

        @Override
        public String usermessage() {
            return String.format("This launcher is outdated; please download the latest version from where you got it. The launch file requires version %s, whereas this launcher is version %d.%d.", this.required, MAJOR_VERSION, MINOR_VERSION);
        }
    }

    public static class Environment {
        public static final URI opaque = URI.create("urn:nothing");
        public Collection<Validator> val = Collections.emptyList();
        public Map<String, String> par = Collections.emptyMap();
        public URI rel = opaque;
        public URI src = null;

        public Environment val(Collection<Validator> val) {
            this.val = val;
            return this;
        }

        public Environment par(Map<String, String> par) {
            this.par = par;
            return this;
        }

        public Environment rel(URI rel) {
            this.rel = rel;
            return this;
        }

        public Environment src(URI src) {
            this.src = src;
            return this;
        }

        public static Environment from(Resource res) {
            return new Environment().val(res.val).rel(res.uri).src(res.uri);
        }
    }
}

