/*
 * Decompiled with CFR 0.152.
 */
package haven.launcher;

import haven.launcher.AWTStatus;
import haven.launcher.Config;
import haven.launcher.Extension;
import haven.launcher.Launcher;
import haven.launcher.PosixArgs;
import haven.launcher.Resource;
import haven.launcher.Status;
import haven.launcher.TTYStatus;
import haven.launcher.Utils;
import java.awt.HeadlessException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;

public class Driver {
    public static void execute(Config cfg) {
        try {
            Launcher l = cfg.launcher;
            Status.current().launch(l);
            l.launch();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void run(Config cfg) {
        try {
            while (!cfg.include.isEmpty()) {
                InputStream src;
                block12: {
                    Resource res = Utils.pop(cfg.include);
                    if (cfg.included.contains(res.uri)) continue;
                    cfg.included.add(res.uri);
                    Path path = res.update();
                    src = Files.newInputStream(path, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        cfg.read(new InputStreamReader(src, Utils.utf8), Config.Environment.from(res));
                        if (src == null) continue;
                        if (throwable == null) break block12;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (src == null) throw throwable3;
                            if (throwable == null) {
                                src.close();
                                throw throwable3;
                            }
                            try {
                                src.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        src.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                src.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Driver.execute(cfg);
    }

    private static void usage(PrintStream out) {
        out.println("usage: launcher.jar [-hq] [-x EXTENSION] [CONFIG-URL|FILE]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            boolean quiet = false;
            PosixArgs opt = PosixArgs.getopt(args, "hqx:");
            if (opt == null) {
                Driver.usage(System.err);
                System.exit(1);
            }
            ArrayList<String> exts = new ArrayList<String>();
            for (char c : opt.parsed()) {
                switch (c) {
                    case 'h': {
                        Driver.usage(System.out);
                        System.exit(0);
                        break;
                    }
                    case 'q': {
                        quiet = true;
                        break;
                    }
                    case 'x': {
                        exts.add(opt.arg);
                    }
                }
            }
            if (!quiet) {
                try {
                    Status.use(new TTYStatus());
                }
                catch (IOException iOException) {
                    try {
                        Status.use(new AWTStatus());
                    }
                    catch (HeadlessException headlessException) {
                        // empty catch block
                    }
                }
            }
            Config cfg = new Config();
            for (String extn : exts) {
                try {
                    if (extn.indexOf("://") < 0) {
                        for (Extension ext : Extension.load(Utils.path(extn))) {
                            ext.init(cfg);
                        }
                        continue;
                    }
                    for (Extension ext : Extension.load(new Resource(new URI(extn), Collections.emptyList()))) {
                        ext.init(cfg);
                    }
                }
                catch (IOException e) {
                    System.err.printf("launcher: could not load extension %s: %s\n", extn, e);
                }
            }
            if (opt.rest.length > 0) {
                try {
                    URI uri;
                    if (opt.rest[0].indexOf("://") < 0) {
                        Path p = Utils.path(opt.rest[0]);
                        try (InputStream src = Files.newInputStream(p, new OpenOption[0]);){
                            cfg.read(new InputStreamReader(src, Utils.utf8), new Config.Environment().rel(p.toUri()));
                        }
                    }
                    try {
                        uri = new URI(opt.rest[0]);
                    }
                    catch (URISyntaxException e) {
                        System.err.printf("launcher: invalid url: %s\n", opt.rest[0]);
                        System.exit(1);
                        return;
                    }
                    Resource res = new Resource(uri, Collections.emptyList());
                    try (InputStream src = Files.newInputStream(res.update(), new OpenOption[0]);){
                        cfg.read(new InputStreamReader(src, Utils.utf8), Config.Environment.from(res));
                    }
                }
                catch (IOException e) {
                    System.err.printf("launcher: could not read %s: %s\n", opt.rest[0], e);
                    System.exit(1);
                    return;
                }
            } else {
                InputStream src = Driver.class.getResourceAsStream("bootstrap.hl");
                if (src == null) {
                    System.err.println("launcher: no bootstreap config found\n");
                    Driver.usage(System.err);
                    System.exit(1);
                }
                try {
                    try {
                        cfg.read(new InputStreamReader(src, Utils.utf8), new Config.Environment());
                    }
                    finally {
                        src.close();
                    }
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
            Driver.run(cfg);
        }
        catch (Throwable t) {
            Status.current().error(t);
        }
        System.exit(0);
    }
}

