/*
 * Decompiled with CFR 0.152.
 */
package haven.launcher;

import haven.launcher.Config;
import haven.launcher.Launcher;
import haven.launcher.NativeLib;
import haven.launcher.Resource;
import haven.launcher.Status;
import haven.launcher.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class JavaLauncher
implements Launcher {
    public final Collection<Resource> classpath = new ArrayList<Resource>();
    public final Collection<String> jvmargs = new ArrayList<String>();
    public final Collection<String> cmdargs = new ArrayList<String>();
    public final Collection<NativeLib> libraries = new ArrayList<NativeLib>();
    public final Map<String, String> sysprops = new HashMap<String, String>();
    public String mainclass = null;
    public Resource execjar = null;
    public int heapsize = 0;

    public JavaLauncher() {
    }

    public JavaLauncher(JavaLauncher that) {
        this.copy(that);
    }

    public void copy(JavaLauncher that) {
        this.classpath.addAll(that.classpath);
        this.jvmargs.addAll(that.jvmargs);
        this.cmdargs.addAll(that.cmdargs);
        this.libraries.addAll(that.libraries);
        this.sysprops.putAll(that.sysprops);
        this.mainclass = that.mainclass;
        this.execjar = that.execjar;
        this.heapsize = that.heapsize;
    }

    protected Path findjvm() {
        Path javadir = Utils.pj(Utils.path(System.getProperty("java.home")), "bin");
        Path jvm = Utils.pj(javadir, "java");
        if (Files.exists(jvm, new LinkOption[0])) {
            return jvm;
        }
        jvm = Utils.pj(javadir, "javaw.exe");
        if (Files.exists(jvm, new LinkOption[0])) {
            return jvm;
        }
        jvm = Utils.pj(javadir, "java.exe");
        if (Files.exists(jvm, new LinkOption[0])) {
            return jvm;
        }
        throw new RuntimeException("could not find a Java executable");
    }

    protected Process launch(ProcessBuilder spec) throws IOException {
        try (Status st = Status.current();){
            st.message("Launching...");
            Process process = spec.start();
            return process;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void launch() throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.findjvm().toFile().toString());
        ArrayList<Path> classpath = new ArrayList<Path>();
        for (Resource resource : this.classpath) {
            classpath.add(resource.update());
        }
        if (this.heapsize > 0) {
            args.add(String.format("-Xmx%dm", this.heapsize));
        }
        for (String string : this.jvmargs) {
            args.add(string);
        }
        for (Map.Entry entry : this.sysprops.entrySet()) {
            args.add(String.format("-D%s=%s", entry.getKey(), entry.getValue()));
        }
        if (!classpath.isEmpty()) {
            args.add("-classpath");
            args.add(String.join((CharSequence)File.pathSeparator, classpath.stream().map(Path::toFile).map(File::toString)::iterator));
        }
        ArrayList<String> libdirs = new ArrayList<String>();
        for (NativeLib lib : this.libraries) {
            if (!lib.use()) continue;
            libdirs.add(lib.extract().toFile().toString());
        }
        if (libdirs.size() > 0) {
            void var4_12;
            String string = String.join((CharSequence)File.pathSeparator, libdirs);
            String cur = System.getProperty("java.library.path");
            if (cur != null && cur.length() > 0) {
                String string2 = string + File.pathSeparator + cur;
            }
            args.add(String.format("-Djava.library.path=%s", var4_12));
        }
        if (this.mainclass != null) {
            args.add(this.mainclass);
        } else if (this.execjar != null) {
            args.add("-jar");
            args.add(this.execjar.update().toString());
        } else {
            throw new RuntimeException("neither main-class nor exec-jar specified for Java launcher");
        }
        for (String string : this.cmdargs) {
            args.add(string);
        }
        ProcessBuilder spec = new ProcessBuilder(args);
        spec.inheritIO();
        this.launch(spec);
    }

    @Override
    public boolean command(String[] words, Config cfg, Config.Environment env) {
        switch (words[0]) {
            case "main-class": {
                if (words.length < 2) {
                    throw new RuntimeException("usage: main-class CLASS-NAME");
                }
                this.mainclass = Config.expand(words[1], env);
                return true;
            }
            case "exec-jar": {
                if (words.length < 2) {
                    throw new RuntimeException("usage: exec-jar URL");
                }
                try {
                    this.execjar = new Resource(env.rel.resolve(new URI(Config.expand(words[1], env))), env.val).referrer(env.src);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("usage: exec-jar URL", e);
                }
                return true;
            }
            case "class-path": {
                if (words.length < 2) {
                    throw new RuntimeException("usage: classpath URL");
                }
                try {
                    this.classpath.add(new Resource(env.rel.resolve(new URI(Config.expand(words[1], env))), env.val).referrer(env.src));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("usage: classpath URL", e);
                }
                return true;
            }
            case "property": {
                if (words.length < 3) {
                    throw new RuntimeException("usage: property NAME VALUE");
                }
                this.sysprops.put(Config.expand(words[1], env), Config.expand(words[2], env));
                return true;
            }
            case "heap-size": {
                if (words.length < 2) {
                    throw new RuntimeException("usage: heap-size MBYTES");
                }
                try {
                    this.heapsize = Integer.parseInt(Config.expand(words[1], env));
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("usage: heap-size MBYTES", e);
                }
                return true;
            }
            case "jvm-arg": {
                if (words.length < 2) {
                    throw new RuntimeException("usage: jvm-arg ARG...");
                }
                for (int i = 1; i < words.length; ++i) {
                    this.jvmargs.add(Config.expand(words[i], env));
                }
                return true;
            }
            case "arguments": {
                if (words.length < 2) {
                    throw new RuntimeException("usage: arguments ARG...");
                }
                for (int i = 1; i < words.length; ++i) {
                    this.cmdargs.add(Config.expand(words[i], env));
                }
                return true;
            }
            case "native-lib": {
                if (words.length < 4) {
                    throw new RuntimeException("usage: native-lib OS ARCH URL [SUB-DIR]");
                }
                try {
                    Pattern os = Pattern.compile(words[1], 2);
                    Pattern arch = Pattern.compile(words[2], 2);
                    Resource lib = new Resource(env.rel.resolve(new URI(Config.expand(words[3], env))), env.val).referrer(env.src);
                    String subdir = "";
                    if (words.length > 4) {
                        subdir = Config.expand(words[4], env);
                    }
                    this.libraries.add(new NativeLib(os, arch, lib, subdir));
                }
                catch (URISyntaxException | PatternSyntaxException e) {
                    throw new RuntimeException("usage: native-lib OS ARCH URL [SUB-DIR]", e);
                }
                return true;
            }
        }
        return false;
    }
}

