/*
 * Decompiled with CFR 0.152.
 */
package haven.launcher;

import haven.launcher.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;

public class NativeLib {
    public final Pattern os;
    public final Pattern arch;
    public final Resource jar;
    public final String prefix;

    public NativeLib(Pattern os, Pattern arch, Resource jar, String subdir) {
        this.os = os;
        this.arch = arch;
        this.jar = jar;
        while (subdir.startsWith("/")) {
            subdir = subdir.substring(1);
        }
        while (subdir.endsWith("/")) {
            subdir = subdir.substring(0, subdir.length() - 1);
        }
        if (subdir.length() > 0) {
            subdir = subdir + "/";
        }
        this.prefix = subdir;
    }

    public boolean use() {
        return this.os.matcher(System.getProperty("os.name")).matches() && this.arch.matcher(System.getProperty("os.arch")).matches();
    }

    public Path extract() throws IOException {
        Path jar = this.jar.update();
        Path dir = this.jar.metafile("lib");
        boolean fresh = false;
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            fresh = true;
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        if (fresh || Files.getLastModifiedTime(jar, new LinkOption[0]).compareTo(Files.getLastModifiedTime(dir, new LinkOption[0])) > 0) {
            JarFile fp = new JarFile(jar.toFile());
            Enumeration<JarEntry> i = fp.entries();
            while (i.hasMoreElements()) {
                String nm;
                JarEntry ent = i.nextElement();
                if (ent.isDirectory() || (nm = ent.getName()).charAt(0) == '.' || !nm.startsWith(this.prefix) || (nm = nm.substring(this.prefix.length())).indexOf(47) >= 0) continue;
                InputStream in = fp.getInputStream(ent);
                Throwable throwable = null;
                try {
                    OutputStream out = Files.newOutputStream(dir.resolve(nm), new OpenOption[0]);
                    Throwable throwable2 = null;
                    try {
                        int rv;
                        byte[] buf = new byte[65536];
                        while ((rv = in.read(buf)) >= 0) {
                            out.write(buf, 0, rv);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            Files.setLastModifiedTime(dir, FileTime.from(Instant.now()));
        }
        return dir;
    }
}

