/*
 * Decompiled with CFR 0.152.
 */
package haven.launcher;

import haven.launcher.Cache;
import haven.launcher.Cached;
import haven.launcher.Status;
import haven.launcher.Utils;
import haven.launcher.ValidationException;
import haven.launcher.Validator;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;

public class Resource {
    public final URI uri;
    public final Collection<Validator> val;
    public URI referrer;

    public Resource(URI uri, Collection<Validator> val) {
        this.uri = uri;
        this.val = val;
    }

    public Resource referrer(URI ref) {
        this.referrer = ref;
        return this;
    }

    private void validate(Cached cf) throws ValidationException {
        block5: {
            if (!this.val.isEmpty()) {
                ArrayList<ValidationException> errors = new ArrayList<ValidationException>();
                for (Validator val : this.val) {
                    try {
                        val.validate(cf);
                        break block5;
                    }
                    catch (ValidationException e) {
                        errors.add(e);
                    }
                }
                ValidationException e = new ValidationException("Could not validate " + this.uri);
                for (ValidationException err : errors) {
                    e.addSuppressed(err);
                }
                throw e;
            }
        }
    }

    public Path metafile(String var) {
        return Cache.get().metafile(this.uri, var);
    }

    public Path update() throws IOException {
        Cache cache = Cache.get();
        Cached cf = cache.update(this, false);
        try (Status st = Status.current();){
            st.messagef("Validating %s...", Utils.basename(this.uri));
            try {
                this.validate(cf);
            }
            catch (ValidationException e) {
                if (cf.fresh) {
                    throw e;
                }
                cf = cache.update(this, true);
                this.validate(cf);
            }
            Path path = cf.path;
            return path;
        }
    }
}

