/*
 * Decompiled with CFR 0.152.
 */
package haven.launcher;

import haven.launcher.Status;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Utils {
    public static final Charset utf8 = Charset.forName("UTF-8");

    public static <E> E pop(Collection<E> c) {
        Iterator<E> i = c.iterator();
        E ret = i.next();
        i.remove();
        return ret;
    }

    public static char num2hex(int num) {
        if (num < 10) {
            return (char)(48 + num);
        }
        return (char)(65 + num - 10);
    }

    public static String byte2hex(byte[] in) {
        StringBuilder buf = new StringBuilder();
        for (byte b : in) {
            buf.append(Utils.num2hex((b & 0xF0) >> 4));
            buf.append(Utils.num2hex(b & 0xF));
        }
        return buf.toString();
    }

    public static String basename(URI uri) {
        String path = uri.getPath();
        int p = path.lastIndexOf(47);
        if (p < 0) {
            return path;
        }
        return path.substring(p + 1);
    }

    public static String[] splitwords(String text) {
        ArrayList<String> words = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        String st = "ws";
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (st == "ws") {
                if (!Character.isWhitespace(c)) {
                    st = "word";
                    continue;
                }
                ++i;
                continue;
            }
            if (st == "word") {
                if (c == '\"') {
                    st = "quote";
                    ++i;
                    continue;
                }
                if (c == '\\') {
                    st = "squote";
                    ++i;
                    continue;
                }
                if (Character.isWhitespace(c)) {
                    words.add(buf.toString());
                    buf = new StringBuilder();
                    st = "ws";
                    continue;
                }
                buf.append(c);
                ++i;
                continue;
            }
            if (st == "quote") {
                if (c == '\"') {
                    st = "word";
                    ++i;
                    continue;
                }
                if (c == '\\') {
                    st = "sqquote";
                    ++i;
                    continue;
                }
                buf.append(c);
                ++i;
                continue;
            }
            if (st == "squote") {
                buf.append(c);
                ++i;
                st = "word";
                continue;
            }
            if (st != "sqquote") continue;
            buf.append(c);
            ++i;
            st = "quote";
        }
        if (st == "word") {
            words.add(buf.toString());
        }
        if (st != "ws" && st != "word") {
            return null;
        }
        return words.toArray(new String[0]);
    }

    public static Certificate[] checkjar(Path path, Status prog) throws IOException {
        HashSet<Certificate> ret = null;
        try (JarFile jar = new JarFile(path.toFile());){
            if (jar.getManifest() == null) {
                Certificate[] certificateArray = new Certificate[]{};
                return certificateArray;
            }
            byte[] buf = new byte[65536];
            Enumeration<JarEntry> i = jar.entries();
            while (i.hasMoreElements()) {
                JarEntry ent = i.nextElement();
                if (ent.isDirectory()) continue;
                if (prog != null) {
                    prog.progress();
                }
                Certificate[] certificateArray = null;
                try (InputStream st = jar.getInputStream(ent);){
                    while (st.read(buf, 0, buf.length) >= 0) {
                    }
                }
                catch (Throwable object) {
                    certificateArray = object;
                    throw object;
                }
                if (ent.getName().startsWith("META-INF")) continue;
                Certificate[] entc = ent.getCertificates();
                if (entc == null || entc.length < 1) {
                    certificateArray = new Certificate[]{};
                    return certificateArray;
                }
                if (ret == null) {
                    ret = new HashSet<Certificate>(Arrays.asList(entc));
                    continue;
                }
                ret.retainAll(Arrays.asList(entc));
                if (ret.size() >= 1) continue;
                certificateArray = new Certificate[]{};
                return certificateArray;
            }
        }
        if (ret == null) {
            return new Certificate[0];
        }
        return ret.toArray(new Certificate[0]);
    }

    public static Path path(String path) {
        return FileSystems.getDefault().getPath(path, new String[0]);
    }

    public static Path pj(Path base, String ... els) {
        for (String el : els) {
            base = base.resolve(el);
        }
        return base;
    }
}

